<?php defined('PF_VERSION') OR exit('Access denied');
/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
class Pf_Faq_Shortcode extends Pf_Plugin_Shortcode_Controller
{

    public function __construct($attrs = array())
    {
        parent::__construct();
        $this->attrs = $attrs;
        $this->view->set_path('/plugins/faq/public/views');
        $this->model = new Pf_Faq_Model;
    }

    private function clean_list_faqs($data)
    {
        $list = array();
        if (!empty($data)) {
            foreach ($data as $id => $value) {
                if ($value['status'] == 1) {
                    $list[$id] = $value;
                }
            }
        }
        return $list;
    }

    private function get_lists($faqs, $page)
    {
        $clean = $this->clean_list_faqs($faqs);
        $total = count($clean);
        $data = array();
        if (!empty($clean) && $total >= $page) {
            $start = ($page - 1) * NUM_PER_PAGE;
            $pages = new PF_Paginator($total, NUM_PER_PAGE, 'page-faq', $page);
            $data['faqs'] = array_slice($clean, $start, NUM_PER_PAGE);
            $data['pagination'] = $pages->page_links(public_url('', true), '', true);
        }
        return $data;
    }

    public function faq_main()
    {
        $type = (isset($this->attrs['type']) && $this->attrs['type'] == 'accordion') ? '' : 'list';
        $faqs = get_option('faq');
        if($type == 'list'){
            $this->data['faqs'] = $faqs;
            return $this->view->render('list', $this->data);
        }else{
            if (!empty($this->attrs['id']) && isset($faqs[$this->attrs['id']])) {
                $this->data['faq'] = $faqs[$this->attrs['id']];
            } else {
                $page = $this->input->has_get('page') ? $this->input->get('page') : 1;
                $this->data = array_merge($this->data, $this->get_lists($faqs, $page));
            }
            return $this->view->render('main', $this->data);
        }
    }

    public function faq_get_faq()
    {
        if (!is_ajax()) {
            return false;
        }
        if ($this->input->has_post('id')) {
            $id = $this->input->post('id');
            $faqs = get_option('faq');
            if (isset($faqs[$id])) {
                echo json_encode($faqs[$id]['list']);
            }
        }
    }

    public function faq_load_list_faqs()
    {
        if (!is_ajax()) {
            return false;
        }
        if ($this->input->has_post('page')) {
            $faqs = get_option('faq');
            $data = $this->get_lists($faqs, $this->input->post('page'));
            echo!empty($data) ? json_encode($data) : '';
        }
    }

}
